function [vecXcorr2,vecYcorr2] = powerFitHorProfile(Loc)
% RABT_logFitHorProfile2
% 
% Author: Koen Hilgersom (2011)
% 01/07/2011
%
% Function file is run by the script 'Rising Air Bubble Technique_vX_X.m'
%
% This function interpolates input points according to a power relationship
% (y=y_max*(x/(W/2))^(1/n), with n an integer determined by the largest
% R-square; usually it will be between 5 and 10).
%
% Input
% Loc           -    Location of the input points
% 
% Output
% vecXcorr2     -    X-vector of output graph
% vecYcorr2     -    Y-vector of output graph
%
%---------------------------------------------------------------------------  
%      Copyright (C) 2011 Technische Universiteit Delft, 
%          Koen Hilgersom
%          K.P.Hilgersom@tudelft.nl (correspondence)
% 
%---------------------------------------------------------------------------  

%This function fits a horizontal logarithmic profile for flow velocity

[thetaSP,rSP]=cart2pol(Loc.SidePTF(:,1)-Loc.SidePTF(2,1),Loc.SidePTF(:,2)-Loc.SidePTF(2,2));
[SidePX,SidePY]=pol2cart([0;0], rSP);
[thetaBub,rBub]=cart2pol(Loc.bubbleTF(:,1)-Loc.SidePTF(2,1),Loc.bubbleTF(:,2)-Loc.SidePTF(2,2));
[BubbleX,BubbleY]=pol2cart(thetaBub-thetaSP(1), rBub);

ave=mean([SidePX(:,1)]);
len1=find(BubbleX(:)<ave,1,'last');
len2=find(BubbleX(:)>ave,1,'first');

r2=ones(35,1);px=ones(35,2);
for n=1:35
    lx=[0; (BubbleX(1:len1)).^(1/n); (abs(BubbleX(len2:end)-SidePX(1))).^(1/n); 0];
    ly=[SidePY(1);BubbleY(1:len1);BubbleY(len2:end);SidePY(2)];
    px(n,:)=polyfit(lx,ly,1);
    y = polyval(px(n,:),lx);
    r2c=r2cum(ly,y);
    r2(n)=r2c(end);
end
[~,n]=max(r2)

vecX1=[0; ((SidePX(2)+1:ave)').^(1/n)];
vecY1=polyval(px(n,:),vecX1);
vecX2=[(-((ave:SidePX(1)-1)'-SidePX(1))).^(1/n);0];
vecY2=polyval(px(n,:),vecX2);

vecX=[SidePX(2):ave,ave:SidePX(1)]';
vecY=[vecY1;vecY2];

[thetaVec,rVec]=cart2pol(vecX,vecY);
[vecXcorr,vecYcorr]=pol2cart(thetaVec+thetaSP(1), rVec);

vecXcorr2=vecXcorr+Loc.SidePTF(2,1);vecYcorr2=vecYcorr+Loc.SidePTF(2,2);



